//
//  Button.h
//  CliqueLeCubeIOS
//
//  Created by Pâris on 08/10/13.
//
//

#ifndef __CliqueLeCubeIOS__Button__
    #define __CliqueLeCubeIOS__Button__

    #include <iostream>

	class Button
    {
        public:
			Button (const char* texte, TTF_Font* police, SDL_Rect pos, SDL_Color fg, SDL_Color bg);
			~Button();
			void render(bool Center);
			void setPosition(int x, int y);
			void changeBg(SDL_Color bg);
			void changeFg(SDL_Color fg);
			void changeText(const char* texte);
			bool isHover(int x, int y);
			void Draw();
			void sendEvent(SDL_Event e);
			void onHover(void (*callback)(Button*));
			void onDefault(void (*callback)(Button*));
        protected:
            char* texte;
			TTF_Font* police;
			SDL_Rect rect, info, pos;
			SDL_Color fg;
			SDL_Color bg;
			SDL_Texture* texture;
			void (*hover)(Button*);
			void (*Default)(Button*);
    };

#endif /* defined(__CliqueLeCubeIOS__Button__) */
